import alice.tucson.api.*;
import alice.logictuple.*;
import alice.tuprolog.Struct;
import alice.tuprolog.Term;
import java.io.*;

/*Thread che si occupa di generare le domande per il quiz e di aggiornare il punteggio
 *degli utenti
 *
 *@author Rossella Rubino
 *@version agosto1 2004 
 */

public class QuizManager extends Thread {
        private TucsonContext context;
        private TupleCentreId quizId,pool,quizIdR,poolR;
        private String answ="";
        
        public QuizManager(AgentId aid,TupleCentreId id,TupleCentreId idr,TupleCentreId p,
         	TupleCentreId pr) throws Exception {
            this.context = Tucson.enterContext(new DefaultContextDescription(aid));
            this.quizId=id;            
            this.quizIdR=idr;
            this.pool=p;
            this.poolR=pr;
            
        }

        public void run(){
            try {           	
            	while (true){         
            		
            		TupleCentreId userTC=null;            		
            		     	
            		LogicTuple quest=LogicTuple.parse("quiz(_,_)");              		
            		
            		LogicTuple q;
            		try{
            			q=context.rd(pool,quest);            		            		  
            		}
            		catch(UnreachableNodeException une){}
            		try{
            			q=context.rd(poolR,quest);    
            		}
            		catch(UnreachableNodeException une){
            			q=context.rd(pool,quest); 
            		}
            		
            		System.out.println(q);        		            		             		
            		
            		String question=q.getArg(0).getArg(0).toString();            		
            		answ=q.getArg(1).getArg(0).toString();            		
            		            		           		
            		LogicTuple msg=LogicTuple.parse("msg(from('Quiz'),host(''),text("+question+"),ts('"+System.currentTimeMillis()+"'))");        		
            		            			        		            		            				
	        		//reperisce l'elenco dei partecipanti al quiz
	        		
	       			Var vt=new Var("Lista");
					LogicTuple tupletemplateEnv=LogicTuple.parse("user(_,host(_),score(_),status(_))");
					TupleArgument ta=new TupleArgument(tupletemplateEnv.toTerm());
					Term t=null;				
					LogicTuple tlist;
					try{
						tlist=context.in(quizId,new LogicTuple("rdall",ta,vt));
						t=vt.toTerm();
					}
					catch(UnreachableNodeException une){}
					
					Var vt2=new Var("Lista");
					try{
						tlist=context.in(quizIdR,new LogicTuple("rdall",ta,vt2));
						t=vt2.toTerm();
					}
					catch(UnreachableNodeException une){}
					alice.tuprolog.Var head;					
					
					Struct lista = (Struct)	t.getTerm();
					
					while (!lista.unify(new Struct())) {
						head = new alice.tuprolog.Var("Head");
						alice.tuprolog.Var tail = new alice.tuprolog.Var("Tail");
						boolean res = lista.unify(new Struct(head,tail));
						lista = (Struct) tail.getTerm();
					
						String tupla=head.toString();						
						LogicTuple ust=LogicTuple.parse(tupla);	
						String usr=ust.getArg(1).getArg(0).toString();
						String hostUser=ust.getArg(1).getArg(1).getArg(0).toString();	
						String status=ust.getArg(1).getArg(3).getArg(0).toString();
						
						if (status.equals("online")){
																			
							userTC=new TupleCentreId(toFlatString(usr.toLowerCase())+" @ "+hostUser);
            			
    	        			//deposita la domanda nei centri di tuple degli utenti				
							context.out(userTC,msg);		
							System.out.println("Quiz> "+toFlatString(msg.getArg(2).getArg(0).toString()));													
						}
	     			}
	     			this.sleep(30000);
	     		}
	     	}                
            catch (Exception ex){
                ex.printStackTrace();
            } 

            
        }
        
        /*metodo usato per eliminare gli apici all'inizio e alla fine di una stringa
	 *
	 *@param st stringa su cui lavorare
	 *@return stringa senza apici
	 */
        private String toFlatString(String st){
            if (st.startsWith("'")&&st.endsWith("'")){
                return st.substring(1,st.length()-1);
            } else {
                return st;
            }
        }
        
        public String getCurrentAnswer(){
        	return answ;
        }
        
        public void win(String u){
        	try{
        		LogicTuple usw=LogicTuple.parse("user("+u+",_,_,_)");
        		try{
        			context.in(quizId,usw);
        		}
        		catch(UnreachableNodeException une){}
        		try{
        			context.in(quizIdR,usw);
        		}
        		catch(UnreachableNodeException une){
        			context.in(quizId,usw);
        		}
        		
        		String hostUser=usw.getArg(1).getArg(0).toString();
        		int score=Integer.parseInt(toFlatString(usw.getArg(2).getArg(0).toString()));
        		score++;
        	
        		LogicTuple usupd=LogicTuple.parse("user('"+u+"',host("+hostUser+"),score("+score+"),status(online))");
        		try{
        			context.out(quizId,usupd);
        		}
        		catch(UnreachableNodeException une){}
        		try{
        			context.out(quizIdR,usupd);
        		}
        		catch(UnreachableNodeException une){}
        		
        		LogicTuple msg=LogicTuple.parse("msg(from('Quiz'),host(''),text('Indovinato...hai accumulato "+score+" punti'),ts('"+System.currentTimeMillis()+"'))");        		
            		            			        		            		            				
	       	    TupleCentreId userTC=new TupleCentreId(toFlatString(u.toLowerCase())+" @ "+hostUser);
            			
          	  //comunica all'utente che ha vinto e il suo attuale punteggio
				context.out(userTC,msg);		
				System.out.println("Quiz> "+toFlatString(msg.getArg(2).getArg(0).toString()));		
			}
			catch (Exception ex){
                ex.printStackTrace();
            }  	
        		
        }
	}